<?php
  require("connzara.php"); 

// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');

// extend TCPF with custom functions
class MYPDF extends TCPDF {

	// Load table data from file
	public function LoadData($file) {
		// Read file lines
		$lines = file($file);
		$data = array();
		foreach($lines as $line) {
			$data[] = explode(';', chop($line));
		}
		return $data;
	}

	// Colored table
	public function ColoredTable($header,$data) {
		// Colors, line width and bold font
		$this->SetFillColor(43, 53, 148);
		$this->SetTextColor(255);
		$this->SetDrawColor(128, 0, 0);
		$this->SetLineWidth(0.3);
		$this->SetFont('', 'B');
		// Header
		$w = array(20,120, 40 );
		$num_headers = count($header);
		for($i = 0; $i < $num_headers; ++$i) {
			$this->Cell($w[$i], 7, $header[$i], 1, 0, 'L', 1);
		}
		$this->Ln();
		// Color and font restoration
		$this->SetFillColor(224, 235, 255);
		$this->SetTextColor(0);
		$this->SetFont('');
		// Data
		$fill = 0;
		foreach($data as $row) {
			$this->Cell($w[0], 6, $row[0], 'LR', 0, 'L', $fill);
			$this->Cell($w[1], 6, $row[1], 'LR', 0, 'L', $fill);
			$this->Cell($w[2], 6, $row[2], 'LR', 0, 'L', $fill); 
			$this->Ln();
			$fill=!$fill;
		}
		$this->Cell(array_sum($w), 0, '', 'T');
	}
}

// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$queryk=mysqli_query($con,'SELECT COMPANYNAME,concat(PHYSICALADD," Phone ",PHONE1,"\n",email,"  ",WEB)PHYSICALADD   FROM companyinfo c;');
$rowa=mysqli_fetch_array($queryk); 
 
  
 
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Skeva Tech Ltd');
$pdf->SetTitle('Income Statement');
$pdf->SetSubject(' Income Statement');
$pdf->SetSubject(' Income Statement'); 
//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, $rowa['COMPANYNAME'] , $rowa['PHYSICALADD'], array(0,64,277), array(0,64,128));

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica', '', 12);

// add a page
$pdf->AddPage();  
 
 $cyr=$_SESSION['cyr'];
 $pyr=$cyr-1; 
// column titles
$pdf->Cell(0,10,'INCOME STATEMENT AND STATEMENT OF COMPREHENSIVE INCOME ',0,0,'C');
 $pdf->Ln(6); 
  $pdf->Cell(0,10,'YEAR ENDED  '.$_SESSION['cyr'],0,0,'C');
 
 $pdf->Ln(); 
 $pdf->SetFont('helvetica','B',10);
  $pdf->Cell(100,10,'  ');
  $pdf->Cell(30,10,'  ');
  $pdf->Cell(30,10,$cyr,'','','R');
  $pdf->Cell(30,10,$pyr,'','','R');
  
  $pdf->Ln(5); 
  $pdf->Cell(100,10,'  ');
  $pdf->Cell(30,10,'Notes');
  $pdf->Cell(30,10,'Ksh','','','R');
  $pdf->Cell(30,10,'Ksh','','','R');
  
  //Revenues 
  $pdf->Ln(5);
  $pdf->Cell(100,10,'Fee Income:');
  $pdf->Cell(30,10,' ','','','R');
  $pdf->Cell(30,10,' ','','','R');
  $pdf->Cell(30,10,' ','','','R');
 
  $pdf->SetFont('helvetica','',10); 
  
   $where='   and month(TrDate) between '.$_SESSION['Fmonth'].' and '.$_SESSION['Tmonth'];
    
  
   $ptot=0;$ctot=0;  
 $qrynn=mysqli_query($con,'SELECT ItId ,Descr FROM feesitems f');
 while($nrw=mysqli_fetch_array($qrynn)){
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
  Amount FROM feestrans  i  join curclass c on(i.stNo=c.stNo) and i.ItId='".$nrw['ItId']."' and yrs=$cyr  where Year(TrDate)=$cyr $where  and TK in('FBLL')   ")); 
     echo mysqli_error($con); 
   $pnrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
  Amount FROM feestrans   i join curclass c on(i.stNo=c.stNo)  and i.ItId='".$nrw['ItId']."' and yrs=$pyr    where Year(TrDate)=$pyr   $where   and TK in('FBLL')   "));
   echo mysqli_error($con);
  if(($inrow['Amount']<>0)||($pnrow['Amount']<>0)){ 
   $pdf->Ln(6);
  $pdf->Cell(100,10,$nrw['Descr']);
  $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,mumball($inrow['Amount']),'','','R');
  $ctot=$ctot+$inrow['Amount'];
  $pdf->Cell(30,10,mumball($pnrow['Amount']),'','','R');
  $ptot=$ptot+$pnrow['Amount'];
 
  }
 }
 /* $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) 
  Amount FROM inctrans i where Year(TrDate)=$cyr $where   and AccId=0 ")); 
     echo mysqli_error($con); 
   $pnrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) 
  Amount FROM inctrans i where Year(TrDate)=$pyr $where  and AccId=0   "));
   echo mysqli_error($con);
  if(($inrow['Amount']<>0)||($pnrow['Amount']<>0)){ 
   $pdf->Ln(6);
  $pdf->Cell(100,10,'Acrued Fee:');
  $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,mumball($inrow['Amount']),'','','R');
  $ctot=$ctot+$inrow['Amount'];
  $pdf->Cell(30,10,mumball($pnrow['Amount']),'','','R');
  $ptot=$ptot+$pnrow['Amount'];
 
  }*/
  
   $pdf->Ln(2);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,' ______________');
   $pdf->Cell(30,10,' ______________');
   
   $pktot=$ptot;
   if($ptot<0){
   $pktot=$ptot*-1;
    $pktot='('.$pktot.')';
   }
   $cktot=$ctot;
   if($ctot<0){
   $cktot=$ctot*-1;
    $cktot='('.$cktot.')';
   }
   $pdf->Ln(6);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,mumball($cktot),'','','R'); 
   $pdf->Cell(30,10,mumball($pktot),'','','R');
  
 
   
    $pktot=$ptot;
   if($ptot<0){
   $pktot=$ptot*-1;
    $pktot='('.$pktot.')';
   }
   $cktot=$ctot;
   if($ctot<0){
   $cktot=$ctot*-1;
    $cktot='('.$cktot.')';
   }
   $pdf->Ln(6);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
     $pdf->Cell(30,10, mumball($cktot),'','','R'); 
   $pdf->Cell(30,10, mumball($pktot),'','','R');
 
   //operational income
   $pdf->SetFont('helvetica','B',10);
   $pdf->Ln(6);
   $pdf->Cell(100,10,'Other Income:');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'');
   $pdf->Cell(30,10,'');
   
   $pdf->SetFont('helvetica','',10);
    $query="select Id AccId,Descr from incsettings where 1 order by Descr ";
   $query=mysqli_query($con,$query); 
   while($row=mysqli_fetch_array($query)){
  
  $pnrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) 
  Amount FROM inctrans i where Year(TrDate)=$pyr $where and stno=1 and tr is null  and AccId='".$row['AccId']."' ")); 
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) 
  Amount FROM inctrans i where Year(TrDate)=$cyr $where   and stno=1 and tr is null and AccId='".$row['AccId']."' "));
     if(($inrow['Amount']<>0)||($pnrow['Amount']<>0)){ 
   $pdf->Ln(6);
  $pdf->Cell(100,10,$row['Descr']);
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,mumball($inrow['Amount']),'','','R');
  $ctot=$ctot+$inrow['Amount']; 
  $pdf->Cell(30,10,mumball($pnrow['Amount']),'','','R');
  $ptot=$ptot+$pnrow['Amount'];
	 }
  }
 
   $pdf->Ln(2);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,' ______________');
   $pdf->Cell(30,10,' ______________');
   
    $pktot=$ptot;
   if($ptot<0){
   $pktot=$ptot*-1;
    $pktot='('.$pktot.')';
   }
   $cktot=$ctot;
   if($ctot<0){
   $cktot=$ctot*-1;
    $cktot='('.$cktot.')';
   }
   $pdf->Ln(6);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
    $pdf->Cell(30,10,mumball($cktot),'','','R');
	$pdf->Cell(30,10,mumball($pktot),'','','R');
  
    //operational Expenses
   $pdf->SetFont('helvetica','B',10);
   $pdf->Ln(8);
   $pdf->Cell(100,10,'Operating Expenses:');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'');
   $pdf->Cell(30,10,'');
   
  $qexp=mysqli_query($con,'SELECT Id,Descr FROM expsettings e;');
  while($rwexp=mysqli_fetch_array($qexp)){
   
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0))  Amount FROM exptrans i where Year(TrDate)=$cyr $where   
  and AccId ='".$rwexp['Id']."'"));

   $pnrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) Amount FROM exptrans i where Year(TrDate)=$pyr
    and AccId ='".$rwexp['Id']."' "));
	 if(($inrow['Amount']<>0)||($pnrow['Amount']<>0)){ 
	
    $pdf->SetFont('helvetica','',10);
   $pdf->Ln(6);
   $pdf->Cell(100,10, $rwexp['Descr']);
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,mumball($inrow['Amount']),'','','R');
   $ctot=$ctot-$inrow['Amount']; 
   $pdf->Cell(30,10,mumball($pnrow['Amount']),'','','R');
   $ptot=$ptot-$pnrow['Amount'];
	 }
  
  } 
   $pdf->Ln(2);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,' ______________');
   $pdf->Cell(30,10,' ______________');
   
   $pktot=$ptot;
  if($ptot<0){
   $pktot=$ptot*-1;
   $pktot=mumball($pktot); 
   $pktot='('.$pktot.')';
  } else{
	$pktot=mumball($pktot); 
	  }
   $cktot=$ctot;
  if($ctot<0){
  $cktot=$ctot*-1;
  $cktot=mumball($cktot); 
   $cktot='('.$cktot.')';
  } else{
	  $cktot=mumball($cktot); 
	  }
   $pdf->Ln(6);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10, $cktot ,'','','R');
   $pdf->Cell(30,10, $pktot ,'','','R');
     
 //
 
 $pdf->lastPage(); 
 $query=mysqli_query($con,"SELECT pdfnm FROM tblpdfs t;");
 while($row=mysqli_fetch_array($query)){
	 $filename = $row["pdfnm"].".pdf";
 
if (file_exists($filename)) {
     unlink($filename);
}
}
	 
	  mysqli_query($con,"delete from tblpdfs ;");
	  $query=mysqli_query($con,"SELECT date_format((select if(sysuse='T',TrDate,now()) state from systactive),'pdf_%H%i%S') nname FROM dual ;");
	  $row=mysqli_fetch_array($query); 
	  $nname=$_SERVER['SCRIPT_FILENAME'];
	    $base=basename($_SERVER['PHP_SELF']); 
		$nname=str_replace($base,'', $nname); 
	   $nname=$nname.'pdfs/'.$row['nname'];
	  mysqli_query($con,"insert into tblpdfs(pdfnm)values('".$nname."');"); 
     $pdf->Output($nname.".pdf","I");